"use client"

import { type ColumnDef } from "@tanstack/react-table"
import { TransformedPendingUser } from "../type/transformers"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { WorkflowButtonRevoke } from "./workflow.button-revoke"
import { Button } from "@/components/ui/button"

export const columns: ColumnDef<TransformedPendingUser>[] = [
  {
    accessorKey: "icon",
    accessorFn: (v) => v.displayName,
    cell: ({ cell }) => {
      const displayName = cell.getValue<string>()
      return (
        <Avatar>
          <AvatarImage src={""} alt={displayName} />
          <AvatarFallback>{INTERNAL__extractFallbackLetter(displayName)}</AvatarFallback>
        </Avatar>
      )
    }
  },
  {
    accessorKey: "username",
    accessorFn: (v) => v.displayName,
    cell: ({ cell }) => {
      const displayName = cell.getValue<string>()
      return (
        <div className="grid flex-1 text-left text-sm leading-tight">
          <span className="truncate">{displayName}</span>
          {/* <span className="truncate text-xs">{}</span> */}
        </div>
      )
    }
  },
  {
    accessorKey: "Actions",
    accessorFn: (value) => value,
    header: () => {
      return 'Actions'
    },
    cell: ({ cell }) => {
      const _value = cell.getValue<TransformedPendingUser>()

      return (
        <div className="flex flex-row gap-2 justify-end">
          <div className="inline-flex -space-x-px rounded-lg shadow-sm shadow-black/5 rtl:space-x-reverse">
            <Button
              variant="outline"
              className="text-xs"
              aria-hidden
              disabled
            >
              Pending
            </Button>
            <WorkflowButtonRevoke
              data={_value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            >Revoke Invitation</WorkflowButtonRevoke>
          </div>
        </div>
      )
    },
  },
]

function INTERNAL__extractFallbackLetter(name: string) {
  if (!name) {
    return "??"
  }

  if (name.length < 2) {
    return "??"
  }

  const split = name.split(' ')
  if (split.length < 2) {
    return name[0] + name[1]
  }

  return split[0][0] + split[1][0]
}

